/***********************************************************************************************************************
/*
/*  ChangeMachineGuid.cpp
/*
/*	When you run this program, it changes the value
/*	of HKLM\Software\Microsoft\Cryptography\MachineGuid
/*	in the registry to a new random guid.  If you're on 
/*	64 bit Windows, both the 32 bit and 64 bit version of 
/*	the registry key get changed and the two versions
/*	get set to different values.
/*
/*  2021 March 24: begun and finished
/*	
/*	Copyright Robert Sacks.  https://mojoware.org
/*	
/**********************************************************************************************************************/

#include "ChangeMachineGuid.h"

#pragma comment ( lib, "Rpcrt4.lib" )

//======================================================================================================================
//  DATA
//======================================================================================================================

wchar_t g_AppTitle[] = L"ChangeMachineGuid";

//======================================================================================================================
//  CODE
//======================================================================================================================

//----------------------------------------------------------------------------------------------------------------------
//   ERROR MESSAGE
//----------------------------------------------------------------------------------------------------------------------
void error_message ( const wchar_t * p )
{
	MessageBox ( 0, p, g_AppTitle, MB_OK | MB_ICONWARNING );
}


//----------------------------------------------------------------------------------------------------------------------
//   GET UUID
//----------------------------------------------------------------------------------------------------------------------
bool get_uuid ( wchar_t * pRet, size_t uRetSize )
{
	assert ( 37 <= uRetSize );

	UUID uuid;
	ZeroMemory ( &uuid, sizeof ( UUID ) );

	RPC_STATUS status = UuidCreate ( &uuid );

	if (RPC_S_UUID_NO_ADDRESS == status )
		return false;

	RPC_WSTR rpcStr = 0;

	status = UuidToString ( &uuid, &rpcStr );

	if (RPC_S_OK != status)
		return false;

	wcscpy_s ( pRet, uRetSize, (wchar_t*) rpcStr );

	RpcStringFree ( &rpcStr );
	
	if ( 36 != wcslen ( pRet ) )
		return false;

	return true;
}


//----------------------------------------------------------------------------------------------------------------------
//   DO IT
//----------------------------------------------------------------------------------------------------------------------
bool do_it ( const unsigned uRegistryViewFlag )
{
	HKEY hKey;
	wchar_t awUuid [37];

	if ( ! get_uuid ( awUuid, ARRAYSIZE(awUuid) ) )
	{
		error_message ( L"Unable to get new uuid." );
		return false;
	}

	LSTATUS status = RegOpenKeyExW (
		HKEY_LOCAL_MACHINE,
		L"SOFTWARE\\Microsoft\\Cryptography",
		0, 
		uRegistryViewFlag | KEY_SET_VALUE, 
		&hKey );

	if ( ERROR_SUCCESS != status )
	{
		error_message ( L"Unable to open registry key" );
		return false;
	}

	status = RegSetValueEx (
		hKey,
		L"MachineGuid",
		0,
		REG_SZ,
		(BYTE*) awUuid,
		2 * ( wcslen(awUuid) + 1 ) );

	if ( ERROR_SUCCESS != status )
	{
		error_message ( L"Unable to set registry key" );
		return false;
	}

	return true;
}


//----------------------------------------------------------------------------------------------------------------------
//  WIN MAIN
//----------------------------------------------------------------------------------------------------------------------
int APIENTRY wWinMain ( HINSTANCE, HINSTANCE, LPWSTR, int )
{
	do_it ( KEY_WOW64_64KEY );
	do_it ( KEY_WOW64_32KEY );

	return TRUE;
}
