/***********************************************************************************************************************
/*
/*	is_64_bit_windows.j.cpp
/*
/*  2021 Jun 05: begun
/*
/*	Copyright Robert Sacks 2021.  https://mojoware.org
/*
/**********************************************************************************************************************/

#include "stdafx.h"
#include <Windows.h>


//======================================================================================================================
//  PROTOTYPES
//======================================================================================================================

static BOOL Is64BitWindows();

//======================================================================================================================
//  CODE
//======================================================================================================================

//-----------------------------------------------------------------------------------------------------------------------
//   IS 64 BIT PROCESS
//-----------------------------------------------------------------------------------------------------------------------
bool is_64_bit_process ()
{
#if defined(_WIN64)
	return true;
#else
	return false;
#endif
}

//-----------------------------------------------------------------------------------------------------------------------
//  IS 64 BIT WINDOWS
// 
//  From Raymond Chen https://devblogs.microsoft.com/oldnewthing/20050201-00/?p=36553
//-----------------------------------------------------------------------------------------------------------------------
BOOL Is64BitWindows()
{
#if defined(_WIN64)
	return TRUE;  // 64-bit programs run only on Win64
#elif defined(_WIN32)
	// 32-bit programs run on both 32-bit and 64-bit Windows
	// so must sniff
	BOOL f64 = FALSE;
	return IsWow64Process(GetCurrentProcess(), &f64) && f64;
#else
	return FALSE; // Win64 does not support Win16
#endif
}


//-----------------------------------------------------------------------------------------------------------------------
//  IS 64 BIT WINDOWS
//-----------------------------------------------------------------------------------------------------------------------
bool is_64_bit_windows ()
{
	return TRUE == Is64BitWindows() ? true : false;
}

