/*********************************************************************************
/*
/*  KillMutex :: cQueryPerformanceCounter.j.cpp
/*
/*  Copyright 2008-2021 Robert Sacks.  https://mojoware.org
/*
/*********************************************************************************/

#include "stdafx.h"
#include "cQueryPerformanceCounter.j.h"
#include <cstdint>

//======================================================================================================================
//  CODE
//======================================================================================================================

//----------------------------------------------------------------------------------------------------------------------
//  CONSTRUCTOR
//----------------------------------------------------------------------------------------------------------------------
cQueryPerformanceCounter :: cQueryPerformanceCounter ()
{
	QueryPerformanceCounter ( &_liTimeBeg );
}


//----------------------------------------------------------------------------------------------------------------------
//  ELAPSED SECONDS
//----------------------------------------------------------------------------------------------------------------------
double cQueryPerformanceCounter :: elapsed_seconds ()
{
	LARGE_INTEGER liTimeEnd, liFrequency;

	QueryPerformanceCounter ( &liTimeEnd );

	QueryPerformanceFrequency ( &liFrequency );

	uint64_t uElapsedTicks = liTimeEnd.QuadPart - _liTimeBeg.QuadPart;

#if 1

	return (double) uElapsedTicks / (double) liFrequency.QuadPart;

#else

	// To guard against loss of precision, multiply
	// before dividing by ticks per second.

	const unsigned uMillion = 100000;

	uElapsedTicks *= uMillion;

	uElapsedTicks /= liFrequency.QuadPart;

	return (double) uElapsedTicks / (double) uMillion;

#endif
}